﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.Models;
using FinkiChattery.Persistence.UnitOfWork;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning
{
    public class AskQuestionCommand : ICommand<Guid>
    {
        public AskQuestionCommand(string title, string text, IEnumerable<Guid> categories)
        {
            Title = title;
            Text = text;
            Categories = categories;
        }

        public string Title { get; }
        public string Text { get; }
        public IEnumerable<Guid> Categories { get; }
    }

    public class AskQuestionHandler : ICommandHandler<AskQuestionCommand, Guid>
    {
        public AskQuestionHandler(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            UnitOfWork = unitOfWork;
            CurrentUser = currentUser;
        }

        public IUnitOfWork UnitOfWork { get; }
        public ICurrentUser CurrentUser { get; }

        public async Task<Guid> Handle(AskQuestionCommand request, CancellationToken cancellationToken)
        {
            var questionCategories = await UnitOfWork.Categories.GetCategories(request.Categories);
            var currentStudent = await UnitOfWork.Students.GetStudent(CurrentUser.Id);

            var questionDatabaseEntity = new Question()
            {
                Title = request.Title,
                Text = request.Text,
                StudentFk = currentStudent.Id,
            };

            foreach (var item in questionCategories)
            {
                questionDatabaseEntity.QuestionCategories.Add(new QuestionCategory()
                {
                    CategoryFk = item.Id
                });
            }

            UnitOfWork.Questions.Add(questionDatabaseEntity);
            await UnitOfWork.SaveAsync();
            return questionDatabaseEntity.Uid;
        }
    }
}
