﻿using FinkiChattery.Commands.Questioning.Validators;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation;

namespace FinkiChattery.Commands.Questioning
{
    public class AskQuestionValidator : AbstractValidator<AskQuestionCommand>
    {
        public AskQuestionValidator(IUnitOfWork unitOfWork)
        {
            RuleFor(x => x.Title).QuestionTitleValidate();
            RuleFor(x => x.Text).QuestionTextValidate();
            RuleFor(x => x.Categories).Cascade(CascadeMode.Stop).ListNotNull().SetValidator(new CategoriesUidsExist(unitOfWork));
        }
    }
}
