﻿using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation.Validators;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning.Validators
{
    public class TeamWithUidExist : AsyncValidatorBase
    {
        public TeamWithUidExist(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        protected override async Task<bool> IsValidAsync(PropertyValidatorContext context, CancellationToken cancellation)
        {
            var teamUid = (Guid)context.PropertyValue;
            return await UnitOfWork.Teams.TeamWithUidExists(teamUid);
        }

        protected override string GetDefaultMessageTemplate()
        {
            return QuestioningErrorCodes.TeamDontExist;
        }
    }
}
