﻿using System;
using System.Linq;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public interface IRepository<T> where T : class
    {
        IQueryable<T> All();

        Task<T> GetByUidAsync(Guid uid);

        Task<T> GetByIdAsync(int id);

        void Add(T entity);
    }
}
