﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Persistence.Repositories.Contracts;
using FinkiChattery.Persistence.UnitOfWork;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Queries.Questioning
{
    public class GetQuestionStateQuery : IQuery<QuestionStateDto>
    {
        public GetQuestionStateQuery(Guid questionUid)
        {
            QuestionUid = questionUid;
        }

        public Guid QuestionUid { get; }
    }

    public class GetQuestionStateQueryHandler : IQueryHandler<GetQuestionStateQuery, QuestionStateDto>
    {
        public GetQuestionStateQueryHandler(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        public async Task<QuestionStateDto> Handle(GetQuestionStateQuery request, CancellationToken cancellationToken)
        {
            return await UnitOfWork.Questions.GetQuestionState(request.QuestionUid);
        }
    }
}
