import { Injectable } from '@angular/core';
import { AnswerQuestionStateViewModel, AnswerResponseQuestionStateViewModel } from 'src/app/shared-app/models';
import { AuthService } from '.';

@Injectable({
  providedIn: 'root'
})
export class StudentQuestionService {
  constructor(private auth: AuthService) {}

  currentUserCanEditAnswer(answer: AnswerQuestionStateViewModel): boolean {
    return this.auth.selfUser?.student?.uid === answer.student.uid;
  }

  currentUserCanEditAnswerResponse(answerResponse: AnswerResponseQuestionStateViewModel): boolean {
    return this.auth.selfUser?.student?.uid === answerResponse.student.uid;
  }
}
