import { HttpErrorResponse } from '@angular/common/http';
import { Action } from '@ngrx/store';

import {
  AnswerQuestionStateViewModel,
  AnswerResponseQuestionStateViewModel,
  PreviewQuestionViewModel,
  QuestionStateViewModel,
  SearchQuestionsQueryViewModel,
  VoteAnswerViewModel,
  VoteType
} from 'src/app/shared-app/models';

export enum QuestionActionTypes {
  GetQuestionState = '[Question] Get state',
  GetQuestionStateSuccess = '[Question] Get state success',
  RespondToAnswer = '[Question] RespondToAnswer',
  RespondToAnswerSuccess = '[Question] RespondToAnswer success',
  SetCorrectAnswer = '[Question] Set Correct Answer',
  SetCorrectAnswerSuccess = '[Question] Set Correct Answer success',
  GetPreviewQuestionsLatest = '[Question] Get preview questions Latest',
  GetPreviewQuestionsLatestSuccess = '[Question] Get preview questions Latest Success',
  GetPreviewQuestionsPopular = '[Question] Get preview questions Popular',
  GetPreviewQuestionsPopularSuccess = '[Question] Get preview questions Popular Success',
  GetSearchQuestions = '[Question] Get search questions',
  GetSearchQuestionsSuccess = '[Question] Get search questions Success',
  VoteAnswer = '[Question] Vote answer',
  VoteAnswerSuccess = '[Question] Vote answer Success',
  AnswerQuestion = '[Question] AnswerQuestion',
  AnswerQuestionSuccess = '[Question] AnswerQuestion Success',
  EditAnswerQuestion = '[Question] EditAnswerQuestion',
  EditAnswerQuestionSuccess = '[Question] EditAnswerQuestion Success',
  EditAnswerResponse = '[Question] EditAnswerResponse',
  EditAnswerResponseSuccess = '[Question] EditAnswerResponse Success',
  EffectStartedWorking = '[Question] Effect Started Working',
  EffectFinishedWorking = '[Question] Effect Finished Working',
  EffectFinishedWorkingError = '[Question] Effect Finished Working error'
}

export class EditAnswerQuestion implements Action {
  readonly type = QuestionActionTypes.EditAnswerQuestion;

  constructor(public questionUid: string, public answerUid: string, public text: string) {}
}

export class EditAnswerQuestionSuccess implements Action {
  readonly type = QuestionActionTypes.EditAnswerQuestionSuccess;

  constructor(public payload: AnswerQuestionStateViewModel, public answerUid: string) {}
}

export class EditAnswerResponse implements Action {
  readonly type = QuestionActionTypes.EditAnswerResponse;

  constructor(public questionUid: string, public answerUid: string, public answerResponseUid: string, public text: string) {}
}

export class EditAnswerResponseSuccess implements Action {
  readonly type = QuestionActionTypes.EditAnswerResponseSuccess;

  constructor(public payload: AnswerResponseQuestionStateViewModel, public answerUid: string, public answerResponseUid: string) {}
}

export class AnswerQuestion implements Action {
  readonly type = QuestionActionTypes.AnswerQuestion;

  constructor(public questionUid: string, public text: string) {}
}

export class AnswerQuestionSuccess implements Action {
  readonly type = QuestionActionTypes.AnswerQuestionSuccess;

  constructor(public payload: AnswerQuestionStateViewModel) {}
}

export class GetQuestionState implements Action {
  readonly type = QuestionActionTypes.GetQuestionState;

  constructor(public questionUid: string) {}
}

export class GetQuestionStateSuccess implements Action {
  readonly type = QuestionActionTypes.GetQuestionStateSuccess;

  constructor(public payload: QuestionStateViewModel) {}
}

export class SetCorrectAnswer implements Action {
  readonly type = QuestionActionTypes.SetCorrectAnswer;

  constructor(public questionUid: string, public answerUid: string) {}
}

export class SetCorrectAnswerSuccess implements Action {
  readonly type = QuestionActionTypes.SetCorrectAnswerSuccess;

  constructor(public payload: string) {}
}

export class GetPreviewQuestionsLatest implements Action {
  readonly type = QuestionActionTypes.GetPreviewQuestionsLatest;

  constructor() {}
}

export class GetPreviewQuestionsLatestSuccess implements Action {
  readonly type = QuestionActionTypes.GetPreviewQuestionsLatestSuccess;

  constructor(public payload: PreviewQuestionViewModel[]) {}
}

export class GetPreviewQuestionsPopular implements Action {
  readonly type = QuestionActionTypes.GetPreviewQuestionsPopular;

  constructor() {}
}

export class GetPreviewQuestionsPopularSuccess implements Action {
  readonly type = QuestionActionTypes.GetPreviewQuestionsPopularSuccess;

  constructor(public payload: PreviewQuestionViewModel[]) {}
}

export class GetSearchQuestions implements Action {
  readonly type = QuestionActionTypes.GetSearchQuestions;

  constructor(public searchText: string, public categories: string[]) {}
}

export class GetSearchQuestionsSuccess implements Action {
  readonly type = QuestionActionTypes.GetSearchQuestionsSuccess;

  constructor(public payload: PreviewQuestionViewModel[], public query: SearchQuestionsQueryViewModel) {}
}

export class VoteAnswer implements Action {
  readonly type = QuestionActionTypes.VoteAnswer;

  constructor(public questionUid: string, public answerUid: string, public voteType: VoteType) {}
}

export class VoteAnswerSuccess implements Action {
  readonly type = QuestionActionTypes.VoteAnswerSuccess;

  constructor(public payload: VoteAnswerViewModel) {}
}

export class RespondToAnswer implements Action {
  readonly type = QuestionActionTypes.RespondToAnswer;

  constructor(public questionUid: string, public answerUid: string, public text: string) {}
}

export class RespondToAnswerSuccess implements Action {
  readonly type = QuestionActionTypes.RespondToAnswerSuccess;

  constructor(public payload: AnswerResponseQuestionStateViewModel, public answerUid: string) {}
}

export class EffectStartedWorking implements Action {
  readonly type = QuestionActionTypes.EffectStartedWorking;

  constructor() {}
}

export class EffectFinishedWorking implements Action {
  readonly type = QuestionActionTypes.EffectFinishedWorking;

  constructor() {}
}

export class EffectFinishedWorkingError implements Action {
  readonly type = QuestionActionTypes.EffectFinishedWorkingError;

  constructor(public payload: HttpErrorResponse) {}
}

export type QuestionAction =
  | GetQuestionStateSuccess
  | GetPreviewQuestionsLatestSuccess
  | GetPreviewQuestionsPopularSuccess
  | GetSearchQuestionsSuccess
  | VoteAnswerSuccess
  | SetCorrectAnswerSuccess
  | RespondToAnswerSuccess
  | AnswerQuestionSuccess
  | EditAnswerQuestionSuccess
  | EditAnswerResponseSuccess
  | EffectStartedWorking
  | EffectFinishedWorking
  | EffectFinishedWorkingError;
