import { Component, OnInit } from '@angular/core';
import { FormControl, Validators, FormGroup } from '@angular/forms';
import { MatDialogRef } from '@angular/material/dialog';

import { QuestionFacadeService } from 'src/app/core/state/question-facade.service';
import { ButtonType } from '../../generic/button/button.models';

@Component({
  selector: 'app-edit-answer-dialog',
  templateUrl: './edit-answer-dialog.component.html',
  styleUrls: ['./edit-answer-dialog.component.scss']
})
export class EditAnswerDialogComponent implements OnInit {
  public ButtonType = ButtonType;
  public textField = new FormControl('', [Validators.required, Validators.maxLength(4000)]);
  public formGroup: FormGroup;
  public questionUid!: string;
  public answerUid!: string;
  public answerResponseUid!: string;
  public textFieldValue!: string;

  constructor(public dialogRef: MatDialogRef<EditAnswerDialogComponent>, private questionFacade: QuestionFacadeService) {
    this.formGroup = new FormGroup({
      text: this.textField
    });
  }

  ngOnInit(): void {
    this.textField.setValue(this.textFieldValue);
  }

  submit(): void {
    this.questionFacade.editAnswer(this.answerUid, this.questionUid, this.textField.value);
    this.dialogRef.close();
  }
}
