import { Injectable } from '@angular/core';
import { MatDialog, MatDialogRef } from '@angular/material/dialog';
import { Observable } from 'rxjs';
import { EditAnswerDialogComponent } from '../components/question/edit-answer-dialog/edit-answer-dialog.component';
// tslint:disable-next-line: max-line-length
import { EditAnswerResponseDialogComponent } from '../components/question/edit-answer-response-dialog/edit-answer-response-dialog.component';
import { RespondToAnswerDialogComponent } from '../components/question/respond-to-answer-dialog/respond-to-answer-dialog.component';

@Injectable({
  providedIn: 'root'
})
export class SharedDialogService {
  constructor(private dialog: MatDialog) {}

  public respondToAnswer(questionUid: string, answerUid: string): Observable<any> {
    let dialogRef: MatDialogRef<RespondToAnswerDialogComponent>;
    dialogRef = this.dialog.open(RespondToAnswerDialogComponent, {
      width: '650px',
      height: 'auto'
    });

    dialogRef.componentInstance.questionUid = questionUid;
    dialogRef.componentInstance.answerUid = answerUid;

    return dialogRef.afterClosed();
  }

  public editResponseToAnswer(questionUid: string, answerUid: string, answerResponseUid: string, text: string): Observable<any> {
    let dialogRef: MatDialogRef<EditAnswerResponseDialogComponent>;
    dialogRef = this.dialog.open(EditAnswerResponseDialogComponent, {
      width: '650px',
      height: 'auto'
    });

    dialogRef.componentInstance.questionUid = questionUid;
    dialogRef.componentInstance.answerUid = answerUid;
    dialogRef.componentInstance.answerResponseUid = answerResponseUid;
    dialogRef.componentInstance.textFieldValue = text;

    return dialogRef.afterClosed();
  }

  public editAnswer(questionUid: string, answerUid: string, text: string): Observable<any> {
    let dialogRef: MatDialogRef<EditAnswerDialogComponent>;
    dialogRef = this.dialog.open(EditAnswerDialogComponent, {
      width: '650px',
      height: 'auto'
    });

    dialogRef.componentInstance.questionUid = questionUid;
    dialogRef.componentInstance.answerUid = answerUid;
    dialogRef.componentInstance.textFieldValue = text;

    return dialogRef.afterClosed();
  }
}
