﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Common.Mediator.Interfaces;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.Repositories.Contracts;
using FinkiChattery.Persistence.UnitOfWork;
using System;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning
{
    public class EditAnswerCommand : ICommand<AnswerQuestionStateDto>
    {
        public EditAnswerCommand(Guid questionUid, Guid answerUid, string text)
        {
            QuestionUid = questionUid;
            AnswerUid = answerUid;
            Text = text;
        }

        public Guid QuestionUid { get; }
        public Guid AnswerUid { get; }
        public string Text { get; }
    }

    public class EditAnswerHandler : ICommandHandler<EditAnswerCommand, AnswerQuestionStateDto>
    {
        public EditAnswerHandler(IUnitOfWork unitOfWork, ICurrentUser currentUser, IEventService eventService)
        {
            UnitOfWork = unitOfWork;
            CurrentUser = currentUser;
            EventService = eventService;
        }

        public IUnitOfWork UnitOfWork { get; }
        public ICurrentUser CurrentUser { get; }
        public IEventService EventService { get; }

        public async Task<AnswerQuestionStateDto> Handle(EditAnswerCommand request, CancellationToken cancellationToken)
        {
            var answer = await UnitOfWork.Answers.GetByUidAsync(request.AnswerUid);
            var student = await UnitOfWork.Students.GetStudent(CurrentUser.Id);

            answer.Text = request.Text;

            await UnitOfWork.SaveAsync();

            return new AnswerQuestionStateDto(answer.Id,
                                              answer.Uid,
                                              answer.Text,
                                              answer.CorrectAnswer,
                                              answer.CreatedOn,
                                              answer.VotesCount,
                                              new AnswerStudentQuestionStateDto(student.Id,
                                                                                student.Uid,
                                                                                student.IndexNumber,
                                                                                student.ImageUrl,
                                                                                student.Reputation),
                                              Enumerable.Empty<AnswerResponseQuestionStateDto>());
        }
    }
}
