﻿using FinkiChattery.Commands.Questioning.Validators;
using FinkiChattery.Commands.Questioning.Validators.Contracts;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation;

namespace FinkiChattery.Commands.Questioning
{
    public class EditAnswerValidator : AbstractValidator<EditAnswerCommand>
    {
        public EditAnswerValidator(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            CascadeMode = CascadeMode.Stop;

            RuleFor(x => x.Text).AnswerTextValidate();
            RuleFor(x => new AnswerInQuestionWithUidExistsDto(x.QuestionUid, x.AnswerUid)).SetValidator(new AnswerInQuestionWithUidExists(unitOfWork));
            RuleFor(x => x.AnswerUid).SetValidator(new StudentIsOwnerOfAnswer(unitOfWork, currentUser));
        }
    }
}
