﻿using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation.Validators;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning.Validators
{
    public class StudentIsOwnerOfAnswerResponse : AsyncValidatorBase
    {
        public StudentIsOwnerOfAnswerResponse(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            UnitOfWork = unitOfWork;
            CurrentUser = currentUser;
        }

        public IUnitOfWork UnitOfWork { get; }
        public ICurrentUser CurrentUser { get; }

        protected override async Task<bool> IsValidAsync(PropertyValidatorContext context, CancellationToken cancellation)
        {
            var answerResponseUid = (Guid)context.PropertyValue;

            return await UnitOfWork.AnswerResponses.StudentIsOwnerOfAnswerResponse(answerResponseUid, CurrentUser.Id);
        }

        protected override string GetDefaultMessageTemplate()
        {
            return QuestioningErrorCodes.StudentDoesNotOwnAnswerResponse;
        }
    }
}
