﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.Repositories.Contracts;
using FinkiChattery.Persistence.UnitOfWork;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning
{
    public class EditAnswerResponseCommand : ICommand<AnswerResponseQuestionStateDto>
    {
        public EditAnswerResponseCommand(Guid questionUid, Guid answerUid, Guid answerResponseUid, string text)
        {
            QuestionUid = questionUid;
            AnswerUid = answerUid;
            AnswerResponseUid = answerResponseUid;
            Text = text;
        }

        public Guid QuestionUid { get; }
        public Guid AnswerUid { get; }
        public Guid AnswerResponseUid { get; }
        public string Text { get; }
    }

    public class EditAnswerResponseHandler : ICommandHandler<EditAnswerResponseCommand, AnswerResponseQuestionStateDto>
    {
        public EditAnswerResponseHandler(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            UnitOfWork = unitOfWork;
            CurrentUser = currentUser;
        }

        public IUnitOfWork UnitOfWork { get; }
        public ICurrentUser CurrentUser { get; }

        public async Task<AnswerResponseQuestionStateDto> Handle(EditAnswerResponseCommand request, CancellationToken cancellationToken)
        {
            var answerResponse = await UnitOfWork.AnswerResponses.GetByUidAsync(request.AnswerResponseUid);
            var student = await UnitOfWork.Students.GetStudent(CurrentUser.Id);

            answerResponse.Text = request.Text;

            await UnitOfWork.SaveAsync();

            return new AnswerResponseQuestionStateDto(answerResponse.Id,
                                                      answerResponse.Uid,
                                                      answerResponse.Text,
                                                      answerResponse.CreatedOn,
                                                      new AnswerResponseStudentQuestionStateDto(student.Id,
                                                                                                student.Uid,
                                                                                                student.IndexNumber,
                                                                                                student.ImageUrl,
                                                                                                student.Reputation));
        }
    }
}
