﻿using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation.Validators;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning.Validators
{
    public class StudentIsOwnerOfAnswer : AsyncValidatorBase
    {
        public StudentIsOwnerOfAnswer(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            UnitOfWork = unitOfWork;
            CurrentUser = currentUser;
        }

        public IUnitOfWork UnitOfWork { get; }
        public ICurrentUser CurrentUser { get; }

        protected override async Task<bool> IsValidAsync(PropertyValidatorContext context, CancellationToken cancellation)
        {
            var answerUid = (Guid)context.PropertyValue;

            return await UnitOfWork.Answers.AnswerIsOwnedByStudent(answerUid, CurrentUser.Id);
        }

        protected override string GetDefaultMessageTemplate()
        {
            return QuestioningErrorCodes.StudentDoesNotOwnAnswer;
        }
    }
}
