﻿using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Models;
using Microsoft.EntityFrameworkCore;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public class AnswerResponseRepo : Repository<AnswerResponse>, IAnswerResponseRepo
    {
        public AnswerResponseRepo(ApplicationDbContext dbContext) : base(dbContext)
        {
        }

        public async Task<bool> StudentIsOwnerOfAnswerResponse(Guid answerResponseUid, long applicationUserId)
        {
            return await DbSet
                .AsNoTracking()
                .Where(x => x.Uid == answerResponseUid && x.Student.ApplicationUserFk == applicationUserId)
                .AnyAsync();
        }
    }
}
