import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { Routes, RouterModule } from '@angular/router';
import { AuthorizedGuard } from './core/guards/authorized.guard';

const routes: Routes = [
  {
    path: 'questioning',
    canActivate: [AuthorizedGuard],
    loadChildren: () => import('./modules/questioning/questioning.module').then((x) => x.QuestioningModule)
  },
  {
    path: '**',
    redirectTo: 'questioning/preview'
  }
];

@NgModule({
  imports: [
    CommonModule,
    RouterModule.forRoot(routes)
  ],
  exports: [RouterModule]
})
export class AppRoutingModule {}
