import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';

import { QuestionFacadeService } from 'src/app/core/state/question-facade.service';

@Component({
  selector: 'app-questions-search',
  templateUrl: './questions-search.component.html',
  styleUrls: ['./questions-search.component.scss']
})
export class QuestionsSearchComponent implements OnInit {
  searchQuestions$ = this.questionFacade.getSearchQuestions();
  searchQuestionsQuery$ = this.questionFacade.getSearchQuestionsQuery();

  constructor(private questionFacade: QuestionFacadeService, private router: Router) {}

  ngOnInit(): void {}

  goToQuestion(uid: string): void {
    this.router.navigateByUrl(`questioning/${uid}`);
  }
}
