export class QuestionStateViewModel {
  constructor(
    public uid: string,
    public title: string,
    public text: string,
    public createdOn: moment.Moment,
    public views: number,
    public lastActiveOn: moment.Moment,
    public student: StudentQuestionStateViewModel,
    public answers: AnswerQuestionStateViewModel[],
    public categories: QuestionCategoryQuestionStateViewModel[],
    public team: TeamQuestionStateViewModel | null
  ) {}
}

export class StudentQuestionStateViewModel {
  constructor(public uid: string, public index: string, public imageUrl: string, public reputation: number) {}
}

export class TeamQuestionStateViewModel {
  constructor(public uid: string, public name: string) {}
}

export class QuestionCategoryQuestionStateViewModel {
  constructor(public uid: string, public name: string) {}
}

export class AnswerQuestionStateViewModel {
  constructor(
    public uid: string,
    public text: string,
    public correctAnswer: boolean,
    public createdOn: moment.Moment,
    public upvotesCount: number,
    public student: AnswerStudentQuestionStateViewModel,
    public answerResponses: AnswerResponseQuestionStateViewModel[]
  ) {}
}

export class AnswerStudentQuestionStateViewModel {
  constructor(public uid: string, public index: string, public imageUrl: string, public reputation: number) {}
}

export class AnswerResponseQuestionStateViewModel {
  constructor(
    public uid: string,
    public text: string,
    public createdOn: moment.Moment,
    public student: AnswerResponseStudentQuestionStateViewModel
  ) {}
}

export class AnswerResponseStudentQuestionStateViewModel {
  constructor(public uid: string, public index: string, public imageUrl: string, public reputation: number) {}
}

export class PreviewQuestionViewModel {
  constructor(
    public uid: string,
    public title: string,
    public createdOn: moment.Moment,
    public views: number,
    public answersCount: number,
    public categories: PreviewQuestionCategoryViewModel[]
  ) {}
}

export class PreviewQuestionCategoryViewModel {
  constructor(public uid: string, public text: string, public nameTranslated: string) {}
}

export class SearchQuestionsQueryViewModel {
  constructor(public text: string) {}
}
