﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Persistence.Repositories.Contracts;
using FinkiChattery.Persistence.UnitOfWork;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Queries.Questioning
{
    public class SearchQuestionsQuery : IQuery<List<QuestionPreviewDto>>
    {
        public SearchQuestionsQuery(string searchText, string categories)
        {
            SearchText = searchText;
            Categories = categories;
        }

        public string SearchText { get; }
        public string Categories { get; }
    }

    public class SearchQuestionsQueryHandler : IQueryHandler<SearchQuestionsQuery, List<QuestionPreviewDto>>
    {
        public SearchQuestionsQueryHandler(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        public async Task<List<QuestionPreviewDto>> Handle(SearchQuestionsQuery request, CancellationToken cancellationToken)
        {
            if (string.IsNullOrEmpty(request.SearchText))
            {
                return new List<QuestionPreviewDto>();
            }

            var categories = new List<Guid>();
            if (!string.IsNullOrEmpty(request.Categories))
            {
                foreach (var item in request.Categories.Split(","))
                {
                    if (Guid.TryParse(item, out Guid result))
                    {
                        categories.Add(result);
                    }
                }
            }

            return await UnitOfWork.Questions.SearchQuestions(request.SearchText, categories);
        }
    }
}
