import { HttpErrorResponse } from '@angular/common/http';
import { PreviewQuestionViewModel, QuestionStateViewModel, SearchQuestionsQueryViewModel } from 'src/app/shared-app/models';

export const questionStateKey = 'question';

export interface QuestionState {
  question: QuestionStateViewModel | null;
  previewQuestionsLatest: PreviewQuestionViewModel[];
  previewQuestionsPopular: PreviewQuestionViewModel[];
  effectWorking: boolean | HttpErrorResponse;
  searchQuestions: PreviewQuestionViewModel[];
  searchQuestionsQuery: SearchQuestionsQueryViewModel | null;
}

export const initialState: QuestionState = {
  question: null,
  previewQuestionsLatest: [],
  previewQuestionsPopular: [],
  searchQuestions: [],
  effectWorking: false,
  searchQuestionsQuery: null
};
