﻿using FinkiChattery.Api.Services;
using FinkiChattery.Common.Mediator;
using FinkiChattery.Common.Mediator.Interfaces;
using FinkiChattery.Common.User;
using FinkiChattery.Common.Validation;
using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Models;
using Hangfire;
using Hangfire.SqlServer;
using MediatR;
using Microsoft.AspNetCore.Authentication.JwtBearer;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Identity;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using System;

namespace FinkiChattery.Api.Server
{
    public static class RegisterServices
    {
        public static void AddMediator(this IServiceCollection services)
        {
            services.AddScoped<IMediatorService, MediatorService>();
            services.AddScoped<IEventService, EventService>();
            services.AddTransient(typeof(IPipelineBehavior<,>), typeof(ValidationBehavior<,>));

            // TODO: REGISTER MEDIATOR HANDLERS WHEN WE CREATE FIRST COMMAND SMENI SO DOMAIN KLASA
            services.AddMediatR(typeof(RegisterServices));
        }

        public static void AddHangfireService(this IServiceCollection services, IConfiguration configuration)
        {
            services.AddHangfire(x =>
            {
                x.UseSqlServerStorage(configuration.GetConnectionString("HangfireConnection"), new SqlServerStorageOptions
                {
                    CommandBatchMaxTimeout = TimeSpan.FromMinutes(5),
                    SlidingInvisibilityTimeout = TimeSpan.FromMinutes(5),
                    QueuePollInterval = TimeSpan.Zero,
                    UseRecommendedIsolationLevel = true,
                    DisableGlobalLocks = true
                });
                x.UseMediatR();
            });
            services.AddHangfireServer();
        }

        public static void AddSingletonServices(this IServiceCollection services)
        {
            services.AddSingleton<AppSettings, AppSettings>();
        }

        public static void AddIdentityService(this IServiceCollection services, IConfiguration configuration)
        {
            var appSettings = new AppSettings(configuration);

            services.AddIdentity<ApplicationUser, ApplicationRole>(o =>
            {
                o.User.RequireUniqueEmail = true;
            })
            .AddEntityFrameworkStores<ApplicationDbContext>()
            .AddDefaultTokenProviders();

            services.AddAuthentication(options =>
            {
                options.DefaultAuthenticateScheme = JwtBearerDefaults.AuthenticationScheme;
                options.DefaultChallengeScheme = JwtBearerDefaults.AuthenticationScheme;
            }).AddJwtBearer(o =>
            {
                o.Authority = appSettings.IdentitySettings.Authority;
                o.Audience = appSettings.IdentitySettings.Audience;
                o.RequireHttpsMetadata = appSettings.IdentitySettings.RequireHttpsMetadata;
            });

            services.AddAuthorization();
        }

        public static void AddEmailService(this IServiceCollection services)
        {
            // TODO: Add email service
            // services.AddScoped<IEmailService, EmailService>();
        }

        public static void AddCurrentUser(this IServiceCollection services)
        {
            services.AddScoped(x =>
            {
                var httpContext = x.GetRequiredService<IHttpContextAccessor>();
                return CurrentUser.GetCurrentUser(httpContext);
            });
        }

        public static void AddRepos(this IServiceCollection services)
        {
        }

        public static void AddOriginUrlSettings(this IServiceCollection services)
        {
            // TODO: ADD ORIGIN URLS 
            /*services.AddScoped<IOriginUrlSettings>(provider =>
            {
                var httpContextAccessor = provider.GetService<IHttpContextAccessor>();

                string originUrl = string.Empty;
                if (httpContextAccessor.HttpContext != null && httpContextAccessor.HttpContext.Request.Headers.TryGetValue("Origin", out StringValues headerValues))
                {
                    if (headerValues.FirstOrDefault() != null)
                    {
                        originUrl = headerValues.FirstOrDefault();
                    }
                }

                return new OriginUrlSettings(originUrl);
            });*/
        }

        public static void AddAwsClient(this IServiceCollection services, IConfiguration configuration)
        {
            // ADD AWS FOR MAILS AND S3 AND CDN
            /*            var appSettings = new AppSettings(configuration);

                        services.AddAWSService<IAmazonS3>();
                        services.AddSingleton<IAmazonS3>(provider =>
                        {
                            return new AmazonS3Client(
                                appSettings.AwsStorageSettings.AccessKey,
                                appSettings.AwsStorageSettings.SecretKey,
                                Amazon.RegionEndpoint.GetBySystemName(appSettings.AwsStorageSettings.StorageServerRegion));
                        });
                        services.AddScoped<IStorageService, AwsStorageService>();*/
        }

        // TODO: ADD HANGFIRE AND SCAFOLD DB IN HANGFIREDB
    }

}
