﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Common.Mediator.Interfaces;
using Hangfire;

namespace FinkiChattery.Common.Mediator
{
    public class EventService : IEventService
    {
        public EventService(IBackgroundJobClient backgroundJob)
        {
            BackgroundJob = backgroundJob;
        }

        public IBackgroundJobClient BackgroundJob { get; }

        public void Enqueue(string jobName, IEvent request)
        {
            BackgroundJob.Enqueue<IMediatorService>(bridge => bridge.PublishAsync(jobName, request));
        }

        public void Enqueue(IEvent request)
        {
            BackgroundJob.Enqueue<IMediatorService>(bridge => bridge.PublishAsync(request));
        }
    }
}
