﻿using FinkiChattery.Common.Mediator.Contracs;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Common.Mediator.Interfaces
{
    public interface IMediatorService
    {
        Task<TResponse> SendAsync<TResponse>(ICommand<TResponse> request, CancellationToken cancellationToken);

        Task<TResponse> SendAsync<TResponse>(ICommand<TResponse> request);

        Task PublishAsync<TNotification>(TNotification notification) where TNotification : IEvent;

        Task PublishAsync<TNotification>(string jobName, TNotification notification) where TNotification : IEvent;
    }
}
