﻿using FinkiChattery.Commands.Questioning;
using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Persistence.Helpers;
using FinkiChattery.Persistence.UnitOfWork;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Api.ApplicationServices.Questioning.EventHandlers
{
    public class UpdateAnswerVotesEventHandler : IEventHandler<AnswerVotedEvent>
    {
        public UpdateAnswerVotesEventHandler(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        public async Task Handle(AnswerVotedEvent notification, CancellationToken cancellationToken)
        {
            var answer = await UnitOfWork.Answers.GetByUidAsync(notification.AnswerUid);

            if (answer == null)
            {
                return;
            }

            switch (notification.VoteType)
            {
                case VoteType.Upvote:
                    answer.VotesCount++;
                    break;
                case VoteType.Downvote:
                    answer.VotesCount--;
                    break;
            }

            await UnitOfWork.SaveAsync();
        }
    }
}
