﻿using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation.Validators;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning.Validators
{
    public class StudentHasGoodReputationAndCanVoteAndAnswer : AsyncValidatorBase
    {
        public StudentHasGoodReputationAndCanVoteAndAnswer(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            UnitOfWork = unitOfWork;
            CurrentUser = currentUser;
        }

        public IUnitOfWork UnitOfWork { get; }
        public ICurrentUser CurrentUser { get; }

        protected override async Task<bool> IsValidAsync(PropertyValidatorContext context, CancellationToken cancellation)
        {
            var student = await UnitOfWork.Students.GetStudent(CurrentUser.Id);

            if (student.ReportReputation > 100)
            {
                return false;
            }

            return true;
        }

        protected override string GetDefaultMessageTemplate()
        {
            return QuestioningErrorCodes.StudentHasBadReputation;
        }
    }
}
