﻿using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Helpers;
using FinkiChattery.Persistence.Models;
using Microsoft.EntityFrameworkCore;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public class VoteRepo : Repository<Vote>, IVoteRepo
    {
        public VoteRepo(ApplicationDbContext dbContext) : base(dbContext)
        {
        }

        public async Task<Vote> GetVoteForAnswerByStudent(Guid answerUid, long userId)
        {
            return await DbSet
                .Where(x => x.Answer.Uid == answerUid &&  x.Student.ApplicationUserFk == userId)
                .FirstOrDefaultAsync();
        }

        public async Task<bool> StudentHasDownvotedAnswer(Guid answerUid, long userId)
        {
            return await DbSet
                .AsNoTracking()
                .Where(x => x.Answer.Uid == answerUid && x.VoteType == VoteType.Downvote && x.Student.ApplicationUserFk == userId)
                .AnyAsync();
        }

        public async Task<bool> StudentHasUpvotedAnswer(Guid answerUid, long userId)
        {
            return await DbSet
                .AsNoTracking()
                .Where(x => x.Answer.Uid == answerUid && x.VoteType == VoteType.Upvote && x.Student.ApplicationUserFk == userId)
                .AnyAsync();
        }
    }
}
