﻿using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using FinkiChattery.Persistence.Models;

namespace FinkiChattery.Persistence.Configurations
{
    public class AnswerConfig : BaseConfig<Answer>
    {
        public AnswerConfig(string schema) : base(schema)
        {
        }

        public override void Configure(EntityTypeBuilder<Answer> builder)
        {
            base.Configure(builder);

            builder.ToTable("Answer", Schema);

            builder.Property(x => x.Text).HasColumnName(@"Text").HasColumnType("nvarchar").IsRequired().HasMaxLength(4000);
            builder.Property(x => x.QuestionFk).HasColumnName(@"QuestionFk").HasColumnType("bigint").IsRequired();
            builder.Property(x => x.StudentFk).HasColumnName(@"StudentFk").HasColumnType("bigint").IsRequired();
            builder.Property(x => x.CorrectAnswer).HasColumnName(@"CorrectAnswer").HasColumnType("bit").IsRequired();
            builder.Property(x => x.CreatedOn).HasColumnName(@"CreatedOn").HasColumnType("smalldatetime").IsRequired();
            builder.Property(x => x.VotesCount).HasColumnName(@"VotesCount").HasColumnType("bigint").IsRequired().HasDefaultValue(0);

            builder.HasOne(x => x.Question).WithMany(x => x.Answers).HasForeignKey(x => x.QuestionFk).OnDelete(DeleteBehavior.Restrict);
            builder.HasOne(x => x.Student).WithMany(x => x.Answers).HasForeignKey(x => x.StudentFk).OnDelete(DeleteBehavior.Restrict);
        }
    }
}
