﻿using FinkiChattery.Persistence.Models;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;

namespace FinkiChattery.Persistence.Configurations
{
    public class VoteConfig : BaseConfig<Vote>
    {
        public VoteConfig(string schema) : base(schema)
        {
        }

        public override void Configure(EntityTypeBuilder<Vote> builder)
        {
            base.Configure(builder);

            builder.ToTable("Vote", Schema);

            builder.Property(x => x.StudentFk).HasColumnName(@"StudentFk").HasColumnType("bigint").IsRequired();
            builder.Property(x => x.AnswerFk).HasColumnName(@"AnswerFk").HasColumnType("bigint").IsRequired();
            builder.Property(x => x.VoteType).HasColumnName(@"VoteType").HasColumnType("tinyint").IsRequired();

            builder.HasOne(x => x.Student).WithMany().HasForeignKey(x => x.StudentFk).OnDelete(DeleteBehavior.Restrict);
            builder.HasOne(x => x.Answer).WithMany(x => x.Votes).HasForeignKey(x => x.AnswerFk).OnDelete(DeleteBehavior.Restrict);
        }
    }
}
