﻿#nullable enable

using System;
using System.Collections.Generic;
using System.Text.Json.Serialization;

namespace FinkiChattery.Contracts.Questioning
{
    public class QuestionStateResponse
    {
        public QuestionStateResponse(long id, Guid uid, string title, string text, DateTime createdOn, long views, DateTime lastActiveOn, StudentQuestionStateResponse studentResponse, IEnumerable<AnswerQuestionStateResponse> answersResponse, IEnumerable<QuestionCategoryQuestionStateResponse> categoriesResponse, TeamQuestionStateResponse? teamResponse)
        {
            Id = id;
            Uid = uid;
            Title = title;
            Text = text;
            CreatedOn = createdOn;
            Views = views;
            LastActiveOn = lastActiveOn;
            StudentResponse = studentResponse;
            AnswersResponse = answersResponse;
            CategoriesResponse = categoriesResponse;
            TeamResponse = teamResponse;
        }

        [JsonIgnore]
        public long Id { get; }
        public Guid Uid { get; }
        public string Title { get; }
        public string Text { get; }
        public DateTime CreatedOn { get; }
        public long Views { get; }
        public DateTime LastActiveOn { get; }
        public StudentQuestionStateResponse StudentResponse { get; }
        public IEnumerable<AnswerQuestionStateResponse> AnswersResponse { get; }
        public IEnumerable<QuestionCategoryQuestionStateResponse> CategoriesResponse { get; }
        public TeamQuestionStateResponse? TeamResponse { get; }
    }

    public class StudentQuestionStateResponse
    {
        public StudentQuestionStateResponse(long id, Guid uid, string index, string imageUrl, long reputation)
        {
            Id = id;
            Uid = uid;
            Index = index;
            ImageUrl = imageUrl;
            Reputation = reputation;
        }

        [JsonIgnore]
        public long Id { get; }
        public Guid Uid { get; }
        public string Index { get; }
        public string ImageUrl { get; }
        public long Reputation { get; }
    }

    public class TeamQuestionStateResponse
    {
        public TeamQuestionStateResponse(long id, Guid uid, string name)
        {
            Id = id;
            Uid = uid;
            Name = name;
        }

        [JsonIgnore]
        public long Id { get; }
        public Guid Uid { get; }
        public string Name { get; }
    }

    public class QuestionCategoryQuestionStateResponse
    {
        public QuestionCategoryQuestionStateResponse(long id, Guid uid, string name)
        {
            Id = id;
            Uid = uid;
            Name = name;
        }

        [JsonIgnore]
        public long Id { get; }
        public Guid Uid { get; }
        public string Name { get; }
    }

    public class AnswerQuestionStateResponse
    {
        public AnswerQuestionStateResponse(long id, Guid uid, string text, bool correctAnswer, DateTime createdOn, long votesCount, AnswerStudentQuestionStateResponse studentResponse, IEnumerable<AnswerResponseQuestionStateResponse> answerResponsesResponse)
        {
            Id = id;
            Uid = uid;
            Text = text;
            CorrectAnswer = correctAnswer;
            CreatedOn = createdOn;
            VotesCount = votesCount;
            StudentResponse = studentResponse;
            AnswerResponsesResponse = answerResponsesResponse;
        }

        [JsonIgnore]
        public long Id { get; }
        public Guid Uid { get; }
        public string Text { get; }
        public bool CorrectAnswer { get; }
        public DateTime CreatedOn { get; }
        public long VotesCount { get; }
        public AnswerStudentQuestionStateResponse StudentResponse { get; }
        public IEnumerable<AnswerResponseQuestionStateResponse> AnswerResponsesResponse { get; }
    }

    public class AnswerStudentQuestionStateResponse
    {
        public AnswerStudentQuestionStateResponse(long id, Guid uid, string index, string imageUrl, long reputation)
        {
            Id = id;
            Uid = uid;
            Index = index;
            ImageUrl = imageUrl;
            Reputation = reputation;
        }

        [JsonIgnore]
        public long Id { get; }
        public Guid Uid { get; }
        public string Index { get; }
        public string ImageUrl { get; }
        public long Reputation { get; }
    }

    public class AnswerResponseQuestionStateResponse
    {
        public AnswerResponseQuestionStateResponse(long id, Guid uid, string text, DateTime createdOn, AnswerResponseStudentQuestionStateResponse studentResponse)
        {
            Id = id;
            Uid = uid;
            Text = text;
            CreatedOn = createdOn;
            StudentResponse = studentResponse;
        }

        [JsonIgnore]
        public long Id { get; }
        public Guid Uid { get; }
        public string Text { get; }
        public DateTime CreatedOn { get; }
        public AnswerResponseStudentQuestionStateResponse StudentResponse { get; }
    }

    public class AnswerResponseStudentQuestionStateResponse
    {
        public AnswerResponseStudentQuestionStateResponse(long id, Guid uid, string index, string imageUrl, long reputation)
        {
            Id = id;
            Uid = uid;
            Index = index;
            ImageUrl = imageUrl;
            Reputation = reputation;
        }

        [JsonIgnore]
        public long Id { get; }
        public Guid Uid { get; }
        public string Index { get; }
        public string ImageUrl { get; }
        public long Reputation { get; }
    }
}
