﻿CREATE TABLE [dbo].[Answer] (
    [Id]            BIGINT           IDENTITY (1, 1) NOT NULL,
    [Uid]           UNIQUEIDENTIFIER NOT NULL,
    [Text]          NVARCHAR (4000)  NOT NULL,
    [QuestionFk]    BIGINT           NOT NULL,
    [StudentFk]     BIGINT           NOT NULL,
    [CorrectAnswer] BIT              NOT NULL,
    [CreatedOn]     SMALLDATETIME    NOT NULL,
    [VotesCount] BIGINT NOT NULL DEFAULT 0, 
    CONSTRAINT [PK_Answer] PRIMARY KEY CLUSTERED ([Id] ASC),
    CONSTRAINT [FK_Answer_Question_QuestionFk] FOREIGN KEY ([QuestionFk]) REFERENCES [dbo].[Question] ([Id]),
    CONSTRAINT [FK_Answer_Student_StudentFk] FOREIGN KEY ([StudentFk]) REFERENCES [dbo].[Student] ([Id])
);


GO
CREATE NONCLUSTERED INDEX [IX_Answer_QuestionFk]
    ON [dbo].[Answer]([QuestionFk] ASC);


GO
CREATE NONCLUSTERED INDEX [IX_Answer_StudentFk]
    ON [dbo].[Answer]([StudentFk] ASC);

