﻿CREATE TABLE [dbo].[Vote] (
    [Id]        BIGINT           IDENTITY (1, 1) NOT NULL,
    [Uid]       UNIQUEIDENTIFIER NOT NULL,
    [StudentFk] BIGINT           NOT NULL,
    [AnswerFk]  BIGINT           NOT NULL,
    [VoteType] TINYINT           NOT NULL, 
    CONSTRAINT [PK_Vote] PRIMARY KEY CLUSTERED ([Id] ASC),
    CONSTRAINT [FK_Vote_Answer_AnswerFk] FOREIGN KEY ([AnswerFk]) REFERENCES [dbo].[Answer] ([Id]),
    CONSTRAINT [FK_Vote_Student_StudentFk] FOREIGN KEY ([StudentFk]) REFERENCES [dbo].[Student] ([Id])
);


GO
CREATE NONCLUSTERED INDEX [IX_Vote_AnswerFk]
    ON [dbo].[Vote]([AnswerFk] ASC);


GO
CREATE NONCLUSTERED INDEX [IX_Vote_StudentFk]
    ON [dbo].[Vote]([StudentFk] ASC);

