﻿using FinkiChattery.Persistence.Configurations;
using FinkiChattery.Persistence.Models;
using Microsoft.AspNetCore.Identity.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore;

namespace FinkiChattery.Persistence.Context
{
    public class ApplicationDbContext : IdentityDbContext<ApplicationUser, ApplicationRole, long>
    {
        public ApplicationDbContext(DbContextOptions<ApplicationDbContext> options) : base(options)
        {
        }

        public DbSet<Answer> Answers { get; set; }
        public DbSet<AnswerResponse> AnswerResponses { get; set; }
        public DbSet<Category> Categories { get; set; }
        public DbSet<Moderator> Moderators { get; set; }
        public DbSet<Question> Questions { get; set; }
        public DbSet<QuestionCategory> QuestionCategories { get; set; }
        public DbSet<Student> Students { get; set; }
        public DbSet<StudentTeam> StudentTeams { get; set; }
        public DbSet<Teacher> Teachers { get; set; }
        public DbSet<TeacherTeam> TeacherTeams { get; set; }
        public DbSet<Team> Teams { get; set; }
        public DbSet<Vote> Votes { get; set; }

        protected override void OnModelCreating(ModelBuilder builder)
        {
            base.OnModelCreating(builder);

            const string schema = "dbo";

            builder.ApplyConfiguration(new AnswerConfig(schema));
            builder.ApplyConfiguration(new AnswerResponseConfig(schema));
            builder.ApplyConfiguration(new CategoryConfig(schema));
            builder.ApplyConfiguration(new ModeratorConfig(schema));
            builder.ApplyConfiguration(new QuestionCategoryConfig(schema));
            builder.ApplyConfiguration(new QuestionConfig(schema));
            builder.ApplyConfiguration(new StudentConfig(schema));
            builder.ApplyConfiguration(new StudentTeamConfig(schema));
            builder.ApplyConfiguration(new TeacherConfig(schema));
            builder.ApplyConfiguration(new TeacherTeamConfig(schema));
            builder.ApplyConfiguration(new TeamConfig(schema));
            builder.ApplyConfiguration(new VoteConfig(schema));
        }
    }
}
