﻿#nullable enable

using System;
using System.Collections.Generic;

namespace FinkiChattery.Persistence.Repositories.Contracts
{
    public class QuestionStateDto
    {
        public QuestionStateDto(long id, Guid uid, string title, string text, DateTime createdOn, long views, DateTime lastActiveOn, StudentQuestionStateDto studentDto, IEnumerable<AnswerQuestionStateDto> answersDto, IEnumerable<QuestionCategoryQuestionStateDto> categoriesDto, TeamQuestionStateDto? teamDto)
        {
            Id = id;
            Uid = uid;
            Title = title;
            Text = text;
            CreatedOn = createdOn;
            Views = views;
            LastActiveOn = lastActiveOn;
            StudentDto = studentDto;
            AnswersDto = answersDto;
            CategoriesDto = categoriesDto;
            TeamDto = teamDto;
        }

        public long Id { get; }
        public Guid Uid { get; }
        public string Title { get; }
        public string Text { get; }
        public DateTime CreatedOn { get; }
        public long Views { get; }
        public DateTime LastActiveOn { get; }
        public StudentQuestionStateDto StudentDto { get; }
        public IEnumerable<AnswerQuestionStateDto> AnswersDto { get; }
        public IEnumerable<QuestionCategoryQuestionStateDto> CategoriesDto { get; }
        public TeamQuestionStateDto? TeamDto { get; }
    }

    public class StudentQuestionStateDto
    {
        public StudentQuestionStateDto(long id, Guid uid, string index, string imageUrl, long reputation)
        {
            Id = id;
            Uid = uid;
            Index = index;
            ImageUrl = imageUrl;
            Reputation = reputation;
        }

        public long Id { get; }
        public Guid Uid { get; }
        public string Index { get; }
        public string ImageUrl { get; }
        public long Reputation { get; }
    }

    public class TeamQuestionStateDto
    {
        public TeamQuestionStateDto(long id, Guid uid, string name)
        {
            Id = id;
            Uid = uid;
            Name = name;
        }

        public long Id { get; }
        public Guid Uid { get; }
        public string Name { get; }
    }

    public class QuestionCategoryQuestionStateDto
    {
        public QuestionCategoryQuestionStateDto(long id, Guid uid, string name)
        {
            Id = id;
            Uid = uid;
            Name = name;
        }

        public long Id { get; }
        public Guid Uid { get; }
        public string Name { get; }
    }

    public class AnswerQuestionStateDto
    {
        public AnswerQuestionStateDto(long id, Guid uid, string text, bool correctAnswer, DateTime createdOn, long votesCount, AnswerStudentQuestionStateDto studentDto, IEnumerable<AnswerResponseQuestionStateDto> answerResponsesDto)
        {
            Id = id;
            Uid = uid;
            Text = text;
            CorrectAnswer = correctAnswer;
            CreatedOn = createdOn;
            VotesCount = votesCount;
            StudentDto = studentDto;
            AnswerResponsesDto = answerResponsesDto;
        }

        public long Id { get; }
        public Guid Uid { get; }
        public string Text { get; }
        public bool CorrectAnswer { get; }
        public DateTime CreatedOn { get; }
        public long VotesCount { get; }
        public AnswerStudentQuestionStateDto StudentDto { get; }
        public IEnumerable<AnswerResponseQuestionStateDto> AnswerResponsesDto { get; }
    }

    public class AnswerStudentQuestionStateDto
    {
        public AnswerStudentQuestionStateDto(long id, Guid uid, string index, string imageUrl, long reputation)
        {
            Id = id;
            Uid = uid;
            Index = index;
            ImageUrl = imageUrl;
            Reputation = reputation;
        }
        public long Id { get; }
        public Guid Uid { get; }
        public string Index { get; }
        public string ImageUrl { get; }
        public long Reputation { get; }
    }

    public class AnswerResponseQuestionStateDto
    {
        public AnswerResponseQuestionStateDto(long id, Guid uid, string text, DateTime createdOn, AnswerResponseStudentQuestionStateDto studentDto)
        {
            Id = id;
            Uid = uid;
            Text = text;
            CreatedOn = createdOn;
            StudentDto = studentDto;
        }

        public long Id { get; }
        public Guid Uid { get; }
        public string Text { get; }
        public DateTime CreatedOn { get; }
        public AnswerResponseStudentQuestionStateDto StudentDto { get; }
    }

    public class AnswerResponseStudentQuestionStateDto
    {
        public AnswerResponseStudentQuestionStateDto(long id, Guid uid, string index, string imageUrl, long reputation)
        {
            Id = id;
            Uid = uid;
            Index = index;
            ImageUrl = imageUrl;
            Reputation = reputation;
        }

        public long Id { get; }
        public Guid Uid { get; }
        public string Index { get; }
        public string ImageUrl { get; }
        public long Reputation { get; }
    }
}
