﻿BEGIN
    SET IDENTITY_INSERT [dbo].[Answer] ON
    MERGE [dbo].[Answer] AS T
    USING
    (
        SELECT *
        FROM
    (
        VALUES
            (1, N'aee193c3-9d36-4ed8-81b2-15eb4ff305f1', N'Answer 1', 1, 1, 1, GETUTCDATE(), 5),
            (2, N'bee193c3-9d36-4ed8-81b2-15eb4ff305f1', N'Answer 2', 1, 1, 0, GETUTCDATE(), 5),
            (3, N'cee193c3-9d36-4ed8-81b2-15eb4ff305f1', N'Answer 3', 2, 1, 1, GETUTCDATE(), 5),
            (4, N'dee193c3-9d36-4ed8-81b2-15eb4ff305f1', N'Answer 4', 2, 1, 0, GETUTCDATE(), 5)
    ) AS temp ([Id], [Uid], [Text], [QuestionFk], [StudentFk], [CorrectAnswer], [CreatedOn], [UpvotesCount])
    ) AS S
    ON T.[ID] = S.[ID]
    WHEN MATCHED THEN
        UPDATE SET T.[Uid] = S.[Uid],
                   T.[Text] = S.[Text],
                   T.[QuestionFk] = S.[QuestionFk],
                   T.[StudentFk] = S.[StudentFk],
                   T.[CorrectAnswer] = S.[CorrectAnswer],
                   T.[UpvotesCount] = S.[UpvotesCount]
    WHEN NOT MATCHED THEN
        INSERT
        (
            [Id],
            [Uid],
            [Text],
            [QuestionFk],
            [StudentFk],
            [CorrectAnswer],
            [CreatedOn],
            [UpvotesCount]
        )
        VALUES
        (S.[Id], S.[Uid], S.[Text], S.[QuestionFk], S.[StudentFk], S.[CorrectAnswer], S.[CreatedOn], S.[UpvotesCount]);
    SET IDENTITY_INSERT [dbo].[Answer] OFF
END