﻿using FinkiChattery.Api.ApplicationServices.Authentication;
using FinkiChattery.Api.ApplicationServices.Questioning;
using FinkiChattery.Commands.Questioning;
using FinkiChattery.Common.Mediator.Interfaces;
using FinkiChattery.Contracts.Questioning;
using FinkiChattery.Queries.Questioning;
using IdentityServer4.AccessTokenValidation;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Threading.Tasks;

namespace FinkiChattery.Api.Controllers.v1
{
    [ApiVersion(ApiVersions.ApiVersion1)]
    [Route("api/v{version:apiVersion}/[controller]")]
    [ApiController]
    public class QuestionsController : ControllerBase
    {
        public QuestionsController(IMediatorService mediatorService)
        {
            MediatorService = mediatorService;
        }

        public IMediatorService MediatorService { get; }

        [HttpPost]
        [Authorize(AuthenticationSchemes = IdentityServerAuthenticationDefaults.AuthenticationScheme, Policy = AuthenticationPolicy.Student)]
        public async Task<IActionResult> AskQuestion([FromBody] AskQuestionRequest request)
        {
            await MediatorService.SendAsync(new AskQuestionCommand(request.Title, request.Text, request.Categories));
            return Ok();
        }

        [HttpGet("{questionUid:Guid}")]
        [Authorize]
        public async Task<IActionResult> GetQuestionState([FromRoute]Guid questionUid)
        {
            var questionDto = await MediatorService.SendQueryAsync(new GetQuestionStateQuery(questionUid));
            return Ok(questionDto.ToQuestionStateResponse());
        }
    }
}
