﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Common.Mediator.Interfaces;
using MediatR;
using System.ComponentModel;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Common.Mediator
{
    public class MediatorService : IMediatorService
    {
        private readonly IMediator mediator;

        public MediatorService(IMediator mediator)
        {
            this.mediator = mediator;
        }

        public async Task<TResponse> SendAsync<TResponse>(ICommand<TResponse> request, CancellationToken cancellationToken)
        {
            return await mediator.Send(request, cancellationToken);
        }

        public async Task<TResponse> SendAsync<TResponse>(ICommand<TResponse> request)
        {
            return await mediator.Send(request);
        }

        public async Task PublishAsync<TNotification>(TNotification notification) where TNotification : IEvent
        {
            await mediator.Publish(notification, default);
        }

        [DisplayName("{0}")]
        public async Task PublishAsync<TNotification>(string jobName, TNotification notification) where TNotification : IEvent
        {
            await mediator.Publish(notification, default);
        }

        public async Task<TResponse> SendQueryAsync<TResponse>(IQuery<TResponse> request, CancellationToken cancellationToken)
        {
            return await mediator.Send(request, cancellationToken);
        }

        public async Task<TResponse> SendQueryAsync<TResponse>(IQuery<TResponse> request)
        {
            return await mediator.Send(request);
        }
    }
}
