import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { AskQuestionRequest } from 'src/app/shared-app/models';
import { BaseApiService } from 'src/app/shared-app/services/base-api.service';

@Injectable({
  providedIn: 'root'
})
export class QuestioningApiService extends BaseApiService {
  constructor(protected http: HttpClient) {
    super(http);
  }

  askQuestion(body: AskQuestionRequest): Observable<string> {
    return this.post('v1/questions', body);
  }
}
