import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { AuthService } from 'src/app/core/services';
import { ButtonType } from '../button/button.models';

@Component({
  selector: 'app-header',
  templateUrl: './header.component.html',
  styleUrls: ['./header.component.scss']
})
export class HeaderComponent implements OnInit {
  ButtonType = ButtonType;

  constructor(public auth: AuthService, private router: Router) {}

  ngOnInit(): void {}

  logout(): void {
    this.auth.logout();
  }

  askQuestion(): void {
    this.router.navigateByUrl('questioning/ask');
  }
}
