import { Component, OnInit } from '@angular/core';
import { QuestionFacadeService } from 'src/app/core/state/question-facade.service';

import { QuestionStateViewModel } from 'src/app/shared-app/models';
import { ButtonType } from '../../generic/button/button.models';

@Component({
  selector: 'app-question-preview',
  templateUrl: './question-preview.component.html',
  styleUrls: ['./question-preview.component.scss']
})
export class QuestionPreviewComponent implements OnInit {
  question!: QuestionStateViewModel;
  working = true;
  ButtonType = ButtonType;
  constructor(private questionFacade: QuestionFacadeService) {}

  ngOnInit(): void {
    this.questionFacade.getQuestion().subscribe((question) => {
      this.question = question;
      this.working = false;
    });
  }
}
