﻿using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Models;
using FinkiChattery.Persistence.Repositories.Contracts;
using Microsoft.EntityFrameworkCore;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public class QuestionRepo : Repository<Question>, IQuestionRepo
    {
        public QuestionRepo(ApplicationDbContext dbContext) : base(dbContext)
        {
        }

        public async Task<QuestionStateDto> GetQuestionState(Guid questionUid)
        {
            // TODO: MAYBE WRITE THIS QUERY AS SP ??
            var questionDto = await DbSet
              .AsNoTracking()
              .Include(x => x.Student)
              .Include(x => x.Team)
              .Include(x => x.Answers).ThenInclude(y => y.Student)
              .Include(x => x.Answers).ThenInclude(y => y.AnswerResponses).ThenInclude(y => y.Student)
              .Include(x => x.QuestionCategories).ThenInclude(y => y.Category)
              .Where(x => x.Uid == questionUid)
              .Select(x => new QuestionStateDto(
                                                x.Id,
                                                x.Uid,
                                                x.Title,
                                                x.Text,
                                                x.CreatedOn,
                                                x.Views,
                                                x.LastActiveOn,
                                                new StudentQuestionStateDto(
                                                  x.Student.Id,
                                                  x.Student.Uid,
                                                  x.Student.IndexNumber,
                                                  x.Student.ImageUrl,
                                                  x.Student.Reputation),
                                                x.Answers.Select(y =>
                                                new AnswerQuestionStateDto(
                                                    y.Id,
                                                    y.Uid,
                                                    y.Text,
                                                    y.CorrectAnswer,
                                                    y.CreatedOn,
                                                    y.UpvotesCount,
                                                    new AnswerStudentQuestionStateDto(
                                                        y.Student.Id,
                                                        y.Student.Uid,
                                                        y.Student.IndexNumber,
                                                        y.Student.ImageUrl,
                                                        y.Student.Reputation),
                                                    y.AnswerResponses.Select(z =>
                                                    new AnswerResponseQuestionStateDto(
                                                        z.Id,
                                                        z.Uid,
                                                        z.Text,
                                                        z.CreatedOn,
                                                        new AnswerResponseStudentQuestionStateDto(
                                                            z.Student.Id,
                                                            z.Student.Uid,
                                                            z.Student.IndexNumber,
                                                            z.Student.ImageUrl,
                                                            z.Student.Reputation))))),
                                                x.QuestionCategories.Select(y =>
                                                new QuestionCategoryQuestionStateDto(
                                                    y.Id,
                                                    y.Uid,
                                                    y.Category.Name)),
                                                x.Team == null ? null : new TeamQuestionStateDto(
                                                    x.Team.Id,
                                                    x.Team.Uid,
                                                    x.Team.Name)))
              .FirstOrDefaultAsync();

            return questionDto;
        }
    }
}
