import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { QuestionFacadeService } from 'src/app/core/state/question-facade.service';
import { ButtonType } from 'src/app/shared-app/components/generic/button/button.models';

@Component({
  selector: 'app-question-preview-general',
  templateUrl: './question-preview-general.component.html',
  styleUrls: ['./question-preview-general.component.scss']
})
export class QuestionPreviewGeneralComponent implements OnInit {
  ButtonType = ButtonType;

  constructor(private questionFacade: QuestionFacadeService, private route: ActivatedRoute) {}

  ngOnInit(): void {
    this.route.params.subscribe((params) => {
      this.questionFacade.fetchQuestion(params.questionUid);
    });
  }
}
