import { Directive, ElementRef, HostListener, Input } from '@angular/core';

import { NotificationService } from 'src/app/core/services/notification.service';

@Directive({
  selector: '[appShareLink]'
})
export class ShareLinkDirective {
  @Input() link: string | null | undefined;

  el: ElementRef;

  constructor(el: ElementRef, private notification: NotificationService) {
    this.el = el;
  }

  @HostListener('click', ['$event']) onClick($event: any): void {
    let contentToCopy = window.location.href;
    if (this.link) {
      contentToCopy = this.link;
    }

    const copyFromElement = document.createElement('input');
    copyFromElement.style.display = 'hide';
    copyFromElement.value = contentToCopy;
    document.body.appendChild(copyFromElement);
    copyFromElement.select();
    document.execCommand('copy');
    document.body.removeChild(copyFromElement);
    this.notification.successNotification('share-link-success');
  }
}
