﻿CREATE TABLE [dbo].[AnswerResponse] (
    [Id]        BIGINT           IDENTITY (1, 1) NOT NULL,
    [Uid]       UNIQUEIDENTIFIER NOT NULL,
    [Text]      NVARCHAR (1)     NOT NULL,
    [AnswerFk]  BIGINT           NOT NULL,
    [StudentFk] BIGINT           NOT NULL,
    [CreatedOn] SMALLDATETIME    NOT NULL,
    CONSTRAINT [PK_AnswerResponse] PRIMARY KEY CLUSTERED ([Id] ASC),
    CONSTRAINT [FK_AnswerResponse_Answer_AnswerFk] FOREIGN KEY ([AnswerFk]) REFERENCES [dbo].[Answer] ([Id]),
    CONSTRAINT [FK_AnswerResponse_Student_AnswerFk] FOREIGN KEY ([AnswerFk]) REFERENCES [dbo].[Student] ([Id])
);


GO
CREATE NONCLUSTERED INDEX [IX_AnswerResponse_AnswerFk]
    ON [dbo].[AnswerResponse]([AnswerFk] ASC);

