import { Component, OnInit } from '@angular/core';
import { AuthService, LoaderService, RedirectService } from './core/services';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})
export class AppComponent implements OnInit {
  constructor(public loader: LoaderService, private redirect: RedirectService, private auth: AuthService) {}

  ngOnInit(): void {
    this.redirect.redirectLoggedInUser();
  }

  public login(): void {
    this.auth.login();
  }
}
