﻿CREATE TABLE [dbo].[Upvote] (
    [Id]        BIGINT           IDENTITY (1, 1) NOT NULL,
    [Uid]       UNIQUEIDENTIFIER NOT NULL,
    [StudentFk] BIGINT           NOT NULL,
    [AnswerFk]  BIGINT           NOT NULL,
    CONSTRAINT [PK_Upvote] PRIMARY KEY CLUSTERED ([Id] ASC),
    CONSTRAINT [FK_Upvote_Answer_AnswerFk] FOREIGN KEY ([AnswerFk]) REFERENCES [dbo].[Answer] ([Id]),
    CONSTRAINT [FK_Upvote_Student_StudentFk] FOREIGN KEY ([StudentFk]) REFERENCES [dbo].[Student] ([Id])
);


GO
CREATE NONCLUSTERED INDEX [IX_Upvote_AnswerFk]
    ON [dbo].[Upvote]([AnswerFk] ASC);


GO
CREATE NONCLUSTERED INDEX [IX_Upvote_StudentFk]
    ON [dbo].[Upvote]([StudentFk] ASC);

