﻿using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using FinkiChattery.Persistence.Models;

namespace FinkiChattery.Persistence.Configurations
{
    public class UpvoteConfig : BaseConfig<Upvote>
    {
        public UpvoteConfig(string schema) : base(schema)
        {
        }

        public override void Configure(EntityTypeBuilder<Upvote> builder)
        {
            base.Configure(builder);

            builder.ToTable("Upvote", Schema);

            builder.Property(x => x.StudentFk).HasColumnName(@"StudentFk").HasColumnType("bigint").IsRequired();
            builder.Property(x => x.AnswerFk).HasColumnName(@"AnswerFk").HasColumnType("bigint").IsRequired();

            builder.HasOne(x => x.Student).WithMany().HasForeignKey(x => x.StudentFk).OnDelete(DeleteBehavior.Restrict);
            builder.HasOne(x => x.Answer).WithMany(x => x.Upvotes).HasForeignKey(x => x.AnswerFk).OnDelete(DeleteBehavior.Restrict);
        }
    }
}
