﻿using FinkiChattery.Identity.Data;
using FinkiChattery.Identity.Models;
using FinkiChattery.Identity.Services;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;

namespace FinkiChattery.Identity
{
    public class Startup
    {
        public IWebHostEnvironment Environment { get; }
        public IConfiguration Configuration { get; }
        public AppSettings AppSettings { get; }

        public Startup(IWebHostEnvironment environment, IConfiguration configuration)
        {
            Environment = environment;
            Configuration = configuration;
            AppSettings = new AppSettings(configuration);
        }

        public void ConfigureServices(IServiceCollection services)
        {
            services.AddControllersWithViews();


            string connectionString = "DefaultConnection";

#if DEBUG_DOCKER
            connectionString = "DefaultConnectionDocker";
#endif

            services.AddDbContextPool<ApplicationDbContext<ApplicationUser>>(options =>
                options.UseSqlServer(Configuration.GetConnectionString(connectionString)));

            services.AddIdentityServerAndIdentityProvider(AppSettings);
            services.RegisterAppServices();

            services.AddCors(options =>
            {
                options.AddPolicy(
                    name: AppSettings.CorsSettings.CorsPolicyName,
                    builder => builder.WithOrigins(AppSettings.CorsSettings.AllowedCorsOrigins).AllowAnyHeader().AllowAnyMethod());
            });
        }

        public void Configure(IApplicationBuilder app)
        {
            if (Environment.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
                app.UseDatabaseErrorPage();
            }

            app.UseHttpsRedirection();
            app.UseStaticFiles();

            app.UseRouting();
            app.UseCors(AppSettings.CorsSettings.CorsPolicyName);

            app.UseAuthentication();
            app.UseAuthorization();
            app.UseIdentityServer();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapDefaultControllerRoute();
            });
        }
    }
}