import { Injectable } from '@angular/core';
import { Router } from '@angular/router';

import { ApplicationUserType } from 'src/app/shared-app/models';
import { AuthService } from './auth.service';

@Injectable({
  providedIn: 'root'
})
export class RedirectService {
  constructor(private router: Router, private auth: AuthService) {}

  public redirectLoggedInUser(): void {
    const currentUser = this.auth.user;

    if (currentUser) {
      switch (currentUser.userType) {
        case ApplicationUserType.Student:
          this.router.navigateByUrl(`questioning/preview`);
          break;
        case ApplicationUserType.Teacher:
          break;
        case ApplicationUserType.Moderator:
          this.router.navigateByUrl(`moderating/categories`);
          break;
      }
    }
  }
}
