import { CategoryAction, CategoryActionTypes } from './category.actions';
import { CategoryState, initialState } from './category.state';

export function reducer(state = initialState, action: CategoryAction): CategoryState {
  switch (action.type) {
    case CategoryActionTypes.GetCategoriesStateSuccess:
      return {
        ...state,
        categories: action.payload
      };
    case CategoryActionTypes.AddCategorySuccess: {
      return {
        ...state,
        categories: [action.payload, ...state.categories]
      };
    }
    case CategoryActionTypes.EffectStartedWorking: {
      return {
        ...state,
        effectWorking: true
      };
    }

    case CategoryActionTypes.EffectFinishedWorking: {
      return {
        ...state,
        effectWorking: false
      };
    }

    case CategoryActionTypes.EffectFinishedWorkingError: {
      return {
        ...state,
        effectWorking: action.payload
      };
    }

    default: {
      return {
        ...state
      };
    }
  }
}
