import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { map } from 'rxjs/operators';
import { NotificationService } from 'src/app/core/services/notification.service';
import { CategoryFacadeService } from 'src/app/core/state/category-facade.service';
import { ButtonType } from 'src/app/shared-app/components/generic/button/button.models';
import { ModeratingDialogService } from '../../services/moderating-dialog.service';

@Component({
  selector: 'app-categories-main',
  templateUrl: './categories-main.component.html',
  styleUrls: ['./categories-main.component.scss']
})
export class CategoriesMainComponent implements OnInit {
  public categories = this.categoriesFacade.getCategories().pipe(map((x) => (x !== null ? x : [])));
  public categoriesColumns: string[] = ['name'];
  public ButtonType = ButtonType;

  constructor(
    private categoriesFacade: CategoryFacadeService,
    private dialog: ModeratingDialogService,
    private notification: NotificationService
  ) {}

  ngOnInit(): void {
    this.categoriesFacade.fetchCategories();
    this.categoriesFacade.effectWorking$.subscribe((effect) => {
      if (effect instanceof HttpErrorResponse) {
        this.notification.handleErrorsNotification(effect.error);
      }
    });
  }

  createNewCategory(): void {
    this.dialog.createNewCategory();
  }
}
